<?php

function getIp($phone) {
    // Массив с данными стран
    $countries = [
        ['c' => '+998', 'n' => 'Uzbekistan', 'iso' => 'UZ', 'ip' => '188.113.192.0'],
        ['c' => '+996', 'n' => 'Kyrgyzstan', 'iso' => 'KG', 'ip' => '158.181.255.0'],
        ['c' => '+994', 'n' => 'Azerbaijan', 'iso' => 'AZ', 'ip' => '188.253.255.0'],
        ['c' => '+972', 'n' => 'Israel', 'iso' => 'IL', 'ip' => '109.67.255.0'],
        ['c' => '+90', 'n' => 'Turkey', 'iso' => 'TR', 'ip' => '109.185.255.0'],
        ['c' => '+7', 'n' => 'Kazakhstan', 'iso' => 'KZ', 'ip' => '164.0.255.0'],
        ['c' => '+61', 'n' => 'Australia', 'iso' => 'AU', 'ip' => '1.159.255.0'],
        ['c' => '+49', 'n' => 'Germany', 'iso' => 'DE', 'ip' => '152.89.163.246'],
        ['c' => '+48', 'n' => 'Poland', 'iso' => 'PL', 'ip' => '103.112.60.0'],
        ['c' => '+47', 'n' => 'Norway', 'iso' => 'NO', 'ip' => '109.189.255.0'],
        ['c' => '+46', 'n' => 'Sweden', 'iso' => 'SE', 'ip' => '104.107.239.0'],
        ['c' => '+45', 'n' => 'Denmark', 'iso' => 'DK', 'ip' => '109.59.255.0'],
        ['c' => '+44', 'n' => 'United Kingdom', 'iso' => 'GB', 'ip' => '109.181.255.0'],
        ['c' => '+43', 'n' => 'Austria', 'iso' => 'AT', 'ip' => '128.131.255.0'],
        ['c' => '+423', 'n' => 'Liechtenstein', 'iso' => 'LI', 'ip' => '212.77.63.0'],
        ['c' => '+421', 'n' => 'Slovakia', 'iso' => 'SK', 'ip' => '147.175.255.0'],
        ['c' => '+420', 'n' => 'Czech Republic', 'iso' => 'CZ', 'ip' => '109.183.0.0'],
        ['c' => '+41', 'n' => 'Switzerland', 'iso' => 'CH', 'ip' => '129.194.0.0'],
        ['c' => '+40', 'n' => 'Romania', 'iso' => 'RO', 'ip' => '109.96.0.0'],
        ['c' => '+39', 'n' => 'Italy', 'iso' => 'IT', 'ip' => '101.59.255.0'],
        ['c' => '+389', 'n' => 'Macedonia', 'iso' => 'MK', 'ip' => '188.44.31.0'],
        ['c' => '+387', 'n' => 'Bosnia and Herzegovina', 'iso' => 'BA', 'ip' => '94.250.127.0'],
        ['c' => '+386', 'n' => 'Slovenia', 'iso' => 'SI', 'ip' => '109.182.255.0'],
        ['c' => '+385', 'n' => 'Croatia', 'iso' => 'HR', 'ip' => '161.53.171.0'],
        ['c' => '+382', 'n' => 'Montenegro', 'iso' => 'ME', 'ip' => '95.155.63.0'],
        ['c' => '+381', 'n' => 'Serbia', 'iso' => 'RS', 'ip' => '178.149.255.0'],
        ['c' => '+377', 'n' => 'Monaco', 'iso' => 'MC', 'ip' => '88.209.127.0'],
        ['c' => '+373', 'n' => 'Moldova', 'iso' => 'MD', 'ip' => '109.185.255.0'],
        ['c' => '+372', 'n' => 'Estonia', 'iso' => 'EE', 'ip' => '103.3.227.0'],
        ['c' => '+371', 'n' => 'Latvia', 'iso' => 'LV', 'ip' => '159.148.108.0'],
        ['c' => '+370', 'n' => 'Lithuania', 'iso' => 'LT', 'ip' => '158.129.255.0'],
        ['c' => '+36', 'n' => 'Hungary', 'iso' => 'HU', 'ip' => '134.255.127.0'],
        ['c' => '+359', 'n' => 'Bulgaria', 'iso' => 'BG', 'ip' => '109.121.255.0'],
        ['c' => '+358', 'n' => 'Finland', 'iso' => 'FI', 'ip' => '103.101.91.0'],
        ['c' => '+356', 'n' => 'Malta', 'iso' => 'MT', 'ip' => '141.8.127.0'],
        ['c' => '+354', 'n' => 'Iceland', 'iso' => 'IS', 'ip' => '103.199.98.0'],
        ['c' => '+353', 'n' => 'Ireland', 'iso' => 'IE', 'ip' => '101.44.255.0'],
        ['c' => '+352', 'n' => 'Luxembourg', 'iso' => 'LU', 'ip' => '103.178.29.0'],
        ['c' => '+351', 'n' => 'Portugal', 'iso' => 'PT', 'ip' => '104.132.255.0'],
        ['c' => '+34', 'n' => 'Spain', 'iso' => 'ES', 'ip' => '1.178.255.0'],
        ['c' => '+33', 'n' => 'France', 'iso' => 'FR', 'ip' => '1.179.127.0'],
        ['c' => '+32', 'n' => 'Belgium', 'iso' => 'BE', 'ip' => '103.109.244.0'],
        ['c' => '+31', 'n' => 'Netherlands', 'iso' => 'NL', 'ip' => '101.33.29.0'],
        ['c' => '+30', 'n' => 'Greece', 'iso' => 'GR', 'ip' => '102.38.248.0'],
        ['c' => '+1', 'n' => 'Canada', 'iso' => 'CA', 'ip' => '100.42.23.0']
    ];

    $cleanPhone = preg_replace('/[^0-9]/', '', $phone);
    
    // Поиск соответствующего кода страны в массиве
    foreach ($countries as $country) {
        $cleanCountryCode = preg_replace('/[^0-9]/', '', $country["c"]);

        if (strpos($cleanPhone, $cleanCountryCode) === 0) { 
            $ipParts = explode('.', $country["ip"]);
            $ipParts[3] = rand(1, 255); // меняем последний элемент на случайное число от 1 до 255
            return implode('.', $ipParts);
        }
    }
    
    // Если не найдено, возвращаем 0.0.0.0
    return "109.185.111.".rand(1, 255);
}

// Проверяем, установлен ли параметр phone в запросе
if (isset($_GET['phone'])) {
    echo getIp($_GET['phone']);
} else {
    echo "Please provide a phone number with the 'phone' parameter.";
}

?>
